/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.installer.ResourceNotFoundException;
import com.izforge.izpack.panels.PathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    protected boolean mustExist = false;
    protected String[] existFiles = null;
    protected PathSelectionPanel pathSelectionPanel;
    protected String emptyTargetMsg = this.getI18nStringForClass("empty_target", "TargetPanel");
    protected String warnMsg = this.getI18nStringForClass("warn", "TargetPanel");
    protected static String defaultInstallDir = null;

    public PathInputPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new IzPanelLayout());
        String string = this.getI18nStringForClass("extendedIntro", "PathInputPanel");
        if ((string == null || string.endsWith("extendedIntro") || string.indexOf(36) > -1) && ((string = this.getI18nStringForClass("intro", "PathInputPanel")) == null || string.endsWith("intro"))) {
            string = "";
        }
        this.add(this.createMultiLineLabel(string));
        this.add(IzPanelLayout.createParagraphGap());
        String string2 = installData.getVariable("EditableTargetPath");
        if (string2 != null && string2.equals("false")) {
            this.add((Component)this.createLabel("info2", "TargetPanel", "open", 2, true), "nextLine");
        } else {
            this.add((Component)this.createLabel("info", "TargetPanel", "open", 2, true), "nextLine");
        }
        this.pathSelectionPanel = new PathSelectionPanel(this, installData);
        this.add((Component)this.pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public void createLayoutBottom() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    public boolean isValidated() {
        Object object;
        String string = this.pathSelectionPanel.getPath();
        boolean bl = true;
        boolean bl2 = Boolean.valueOf(this.idata.getVariable("modify.izpack.install"));
        if (bl2) {
            this.mustExist = true;
            object = new File(this.pathSelectionPanel.getPath() + File.separator + ".installationinformation");
            if (!((File)object).exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.required.forModificationInstallation"));
                return false;
            }
        }
        if (string.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString("PathInputPanel.required"));
                return false;
            }
            bl = this.emitWarning(this.parent.langpack.getString("installer.warning"), this.emptyTargetMsg);
        }
        if (!bl) {
            return bl;
        }
        if (string.startsWith("~")) {
            object = System.getProperty("user.home");
            string = (String)object + string.substring(1);
        }
        object = new File(string).getAbsoluteFile();
        string = ((File)object).toString();
        this.pathSelectionPanel.setPath(string);
        if (this.isMustExist()) {
            if (!((File)object).exists()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString(this.getI18nStringForClass("required", "PathInputPanel")));
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.parent.langpack.getString(this.getI18nStringForClass("notValid", "PathInputPanel")));
                return false;
            }
        } else {
            if (!this.isWriteable()) {
                this.emitError(this.parent.langpack.getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
                return false;
            }
            if (((File)object).exists()) {
                int n = this.askQuestion(this.parent.langpack.getString("installer.warning"), this.warnMsg, 37, 47);
                bl = n == 47;
            } else {
                String string2 = this.idata.getVariable("ShowCreateDirectoryMessage");
                if (string2 == null || Boolean.getBoolean(string2)) {
                    bl = this.emitNotificationFeedback(this.getI18nStringForClass("createdir", "TargetPanel") + "\n" + string);
                }
            }
        }
        return bl;
    }

    protected boolean pathIsValid() {
        if (this.existFiles == null) {
            return true;
        }
        for (String string : this.existFiles) {
            File file = new File(this.pathSelectionPanel.getPath(), string).getAbsoluteFile();
            if (file.exists()) continue;
            return false;
        }
        return true;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean bl) {
        this.mustExist = bl;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] stringArray) {
        this.existFiles = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadDefaultInstallDir(InstallerFrame installerFrame, InstallData installData) {
        if (PathInputPanel.getDefaultInstallDir() != null) {
            return;
        }
        BufferedReader bufferedReader = null;
        try {
            InputStream inputStream = null;
            String string = System.getProperty("os.name");
            string = string.replace(' ', '_');
            string = string.toLowerCase();
            try {
                inputStream = installerFrame.getResource("TargetPanel.dir.".concat(string));
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            if (inputStream == null) {
                if (OsVersion.IS_WINDOWS) {
                    try {
                        inputStream = installerFrame.getResource("TargetPanel.dir.windows");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else if (OsVersion.IS_OSX) {
                    try {
                        inputStream = installerFrame.getResource("TargetPanel.dir.macosx");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {}
                } else {
                    try {
                        inputStream = installerFrame.getResource("TargetPanel.dir.unix");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (inputStream == null) {
                try {
                    inputStream = installerFrame.getResource("TargetPanel.dir");
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
            }
            if (inputStream != null) {
                String string2;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                while ((string2 = bufferedReader.readLine()) != null && "".equals(string2 = string2.trim())) {
                }
                defaultInstallDir = string2;
                VariableSubstitutor variableSubstitutor = new VariableSubstitutor(installData.getVariables());
                defaultInstallDir = variableSubstitutor.substitute(defaultInstallDir, null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            defaultInstallDir = null;
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isWriteable() {
        File file = IoHelper.existingParent(new File(this.pathSelectionPanel.getPath()));
        if (file == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File file2 = File.createTempFile("izWrTe", ".tmp", file);
                file2.deleteOnExit();
            }
            catch (IOException iOException) {
                Debug.trace(iOException.toString());
                return false;
            }
            return true;
        }
        return file.canWrite();
    }

    public static String getDefaultInstallDir() {
        return defaultInstallDir;
    }

    public static void setDefaultInstallDir(String string) {
        defaultInstallDir = string;
    }
}

